<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<!-- CDA document -->
    <xsl:template match="/">
        <html>
            <head />
            <body>            
				<xsl:apply-templates select="n1:ClinicalDocument"/>            
            </body>
        </html>
    </xsl:template>
<!-- Document title -->    
<xsl:template match="n1:ClinicalDocument/n1:title">
<h3>
<xsl:value-of select="."></xsl:value-of>
</h3>
<br />
</xsl:template>

<!-- StructuredBody -->
<xsl:template match="n1:component/n1:StructuredBody">
	<xsl:apply-templates/>
</xsl:template>

<!-- Component Section -->
<xsl:template match="n1:component/n1:section">
	<xsl:apply-templates select="n1:title"/>
	<xsl:apply-templates select="n1:text"/>
	<xsl:apply-templates select="n1:component2"/>
	<xsl:apply-templates select="n1:component1"/>
</xsl:template>

<!-- Component2 Section -->
<xsl:template match="n1:component2/n1:section">
	<xsl:apply-templates select="n1:title"/>
	<xsl:apply-templates select="n1:text"/>
</xsl:template>

<!-- Title of Section  -->
<xsl:template match="n1:title">
	<h4>
	<xsl:value-of select="."/> 
	</h4>
</xsl:template>

<!--  Text of Section -->
<xsl:template match="n1:text">
	<xsl:apply-templates select="n1:paragraph|n1:list|n1:table|n1:content|text()"/>
	<br />
</xsl:template>

<!--  Component2 of Section -->
<xsl:template match="n1:component2">
	<xsl:apply-templates/>
	</xsl:template>

<!--  Component1 of Section -->
<xsl:template match="n1:component1">
	<xsl:apply-templates />
</xsl:template>



<!-- Paragraph -->
<xsl:template match="n1:paragraph">
	<xsl:apply-templates select="n1:caption"/>
	<xsl:apply-templates select="n1:content"/>
</xsl:template>

<!-- List -->
<xsl:template match="n1:list">
	<xsl:apply-templates select="n1:caption"/>
	<xsl:apply-templates select="n1:item"/>
</xsl:template>
<!-- Caption -->
<xsl:template match="n1:caption">
	<h5>
	<xsl:value-of select="."/> 
	</h5>
	<br />
</xsl:template>
<!-- Item -->
<xsl:template match="n1:item">	
	<xsl:apply-templates/>
	<br />
</xsl:template>

<!-- Tables -->
<!-- 
     Tables
	 
     just copy over the entire subtree, as is
	 except that the children of CAPTION are possibly handled by
	 other templates in this stylesheet
  -->
	<xsl:template match="n1:table|n1:table/n1:caption|n1:thead|n1:tfoot|n1:tbody|n1:colgroup|n1:col|n1:tr|n1:th|n1:td">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:th">
		<th align="left">
			<xsl:apply-templates/>
		</th>
	</xsl:template>
	<xsl:template match="n1:table">
		<!--  Tables forced no borders and width = 100%, TI 10.4.2002-->
		<table border="0" width="100%">
			<xsl:apply-templates/>
		</table>
	</xsl:template>
	<xsl:template match="n1:table/n1:caption">
		<h3>
			<xsl:apply-templates/>
		</h3>
	</xsl:template>

</xsl:stylesheet>